
import cadquery as cq

# Define the dimensions of the rectangle and the holes
length = 100.0  # Length of the rectangle
width = 50.0  # Width of the rectangle
thickness = 10.0  # Thickness of the rectangle
hole_dia = 5.0  # Diameter of the holes

# Create the rectangle
result = cq.Workplane("XY").box(length, width, thickness)

# Cut the holes, adjusting positions for top left corner alignment
hole_start_x = 10  # Distance from the left edge of the rectangle to the first hole
hole_y = 40  # Distance from the bottom edge of the rectangle to align holes at the top
hole_spacing = 15  # Distance between the centers of the holes along the length

# Cut the holes
for i in range(3):
    x_position = hole_start_x + i * hole_spacing
    result = result.faces(">Z").workplane().pushPoints([(x_position, hole_y)]).hole(hole_dia)

# Export the result with the correct file name
result.val().exportStl("Refine_1.stl")
