
import cadquery as cq

# Create a square
result = cq.Workplane("front").rect(2, 2)

# Attach a semi-circle to the top of the square
# Ensure the semi-circle starts at (-1, 1) and ends at (1, 1)
result = result.moveTo(-1, 1).threePointArc((0,2), (1, 1))

# Extrude the sketch
result = result.close().extrude(1)

# Save the output
result.val().exportStl("Refine_1.stl")
