
import cadquery as cq

# Define the dimensions of the trapezoid
base1 = 10.0  # shorter base of the trapezoid
base2 = 20.0  # longer base of the trapezoid
height = 15.0  # vertical height of the trapezoid
thickness = 5.0  # thickness of the extrusion

# Calculate the offsets for the bases to align them to the center
offset = (base2 - base1) / 2

# Create the trapezoid sketch ensuring equal angles
result = (
    cq.Workplane("front")
    .moveTo(-base2 / 2, 0)  # Start from the bottom left
    .lineTo(-base1 / 2 + offset, height)  # Line to top left
    .lineTo(base1 / 2 + offset, height)  # Line to top right
    .lineTo(base2 / 2, 0)  # Line to bottom right
    .close()  # Close the sketch to form a loop
)

# Extrude the sketch to create the prism with equal angles ensuring regular trapezoid
result = result.extrude(thickness)

# Review the model, adjust alignments if necessary, and export the result
result.val().exportStl("Refine_2.stl")
