
import cadquery as cq

# Create a rectangle
r = cq.Workplane("front").rect(10, 5)

# Extrude the sketch
r = r.extrude(2)

# Round two corners of the same long edge
r = r.edges("|Z and >X").fillet(1)
r = r.edges("|Z and <X").fillet(1)

# Create two small, evenly-spaced circular holes on the same side as the rounded corners
r = r.faces(">Z").workplane().pushPoints([(-3, 2), (3, 2)]).hole(0.5)

# Save the output
r.val().exportStl("Generated.stl")
