
import cadquery as cq

# Create a rectangle
rectangle = cq.Workplane("front").rect(10, 5)

# Extrude the sketch
extruded_rectangle = rectangle.extrude(2)

# Round two corners of the same long edge
rounded_extrusion = extruded_rectangle.edges("|Z and >X").fillet(1)
rounded_extrusion = rounded_extrusion.edges("|Z and <X").fillet(1)

# Create two small, evenly-spaced circular holes on the same side as the rounded corners
final_object = rounded_extrusion.faces(">Z").workplane().pushPoints([(-3, 2), (3, 2)]).hole(0.5)

# Save the output with the specified filename
final_object.val().exportStl("Refine_1.stl")
