
import cadquery as cq

# Create a sketch with two overlapping circles by translating the second circle
result = cq.Workplane("XY").circle(10.0).moveTo(5, 0).circle(10.0).extrude(1)

# Correct the cutout overlap by centering and properly aligning smaller circles
# Smaller circles need to be more overlapping and aligned similarly to the large circles.
cutout = cq.Workplane("XY").moveTo(3.5, 0).circle(5.0).moveTo(6.5, 0).circle(5.0).extrude(1)

# Cut the adjusted overlapping smaller circles from the original shape to create the central hole
result = result.cut(cutout)

# Export the result with the corrections
result.val().exportStl("Refine_2.stl")
