
import cadquery as cq

# Dimensions for the main plate
plate_height = 60.0
plate_width = plate_height * (2/3)
plate_thickness = 10.0

# Dimensions for the slot
slot_width = 5.0
slot_depth = plate_thickness  # Assuming slot depth should cover the entire plate thickness

# Create the main plate
plate = cq.Workplane("front").box(plate_width, plate_thickness, plate_height)

# Create the slot, the slot should be a through slot over the height direction of the plate
slot = (
    plate.faces(">Z")  # Start from the top face of the plate
    .workplane(centerOption="CenterOfBoundBox")  # Center workplane on the top face of the plate
    .rect(slot_width, plate_thickness)  # Create a rectangle for the slot
    .extrude(-plate_height)  # Extrude the slot downwards through the plate
)

# Subtract the slot from the plate
result = plate.cut(slot)

# Export the result - Ensure the export path is correct and accessible
result.val().exportStl("/path/to/your/directory/Refine_1.stl")
