
import cadquery as cq

# Parameters for the main square and the small rectangles
main_square_side = 10.0
rectangle_width = 1.0
rectangle_height = 2.0
extrude_depth = 0.5

# Create the main square and extrude it into a solid
main_square = cq.Workplane("front")\
    .rect(main_square_side, main_index_side)\
    .extrude(extrude_depth)

# Create the first small rectangle, position and extrude it into a solid
left_rectangle = cq.Workplane("front")\
    .rect(rectangle_width, rectangle_height)\
    .translate((-main_square_side/2 + rectangle_width/2, 0))\
    .extrude(extrude_depth)

# Create the second small rectangle, position and extrude it into a solid
right_rectangle = cq.Workplane("front")\
    .rect(rectangle_width, rectangle_height)\
    .translate((main_square_side/2 - rectangle_width/2, 0))\
    .extrude(extrude_depth)

# Union the main square with the left and right rectangles
result = main_square\
    .union(left_rectangle)\
    .union(right_rectangle)

# Save the output
result.val().exportStl("Refine_1.stl")
