
import cadquery as cq

# Parameters for the main square and the small rectangles
main_square_side = 10.0
rectangle_width = 1.0
rectangle_height = 2.0
extrude_depth = 0.5

# Create the main square
result = cq.Workplane("front") \
    .rect(main_square_side, main_square_side) \
    .rect(rectangle_width, rectangle_height, forConstruction=True) \
    .vertices("<X").translate((-main_square_side/2, 0))\
    .rect(rectangle_width, rectangle_height) \
    .vertices(">X").translate((main_square_side/2, 0))\
    .rect(rectangle_width, rectangle_height) \
    .extrude(extrude_depth)

# Save the output
result.val().exportStl("Refine_2.stl")
