
import cadquery as cq

# Parameters for the bucket and handle
bucket_height = 10.0
bucket_radius = 5.0
bucket_thickness = 0.5
handle_diameter = 0.5
handle_length = 2 * bucket_radius + 2.0  # slightly larger than the diameter

# Create the outer cylinder of the bucket
bucket = cq.Workplane("XY").circle(bucket_radius).extrude(bucket_height)

# Create the inner cylinder of the bucket
bucket = bucket.faces(">Z").workplane().circle(bucket_radius - bucket_thickness).cutBlind(-bucket_height + bucket_thickness)

# Adjust handle placement to pass through the cylinder sides
handle = cq.Workplane("XY").transformed(offset=(0, 0, bucket_height - bucket_thickness - handle_diameter / 2)).circle(handle_diameter / 2).extrude(handle_length, both=True)

# Rotate handle to the correct orientation
handle = handle.rotate((1, 0, 0), (0, 0, 1), 90)

# Combine the bucket and the handle
result = bucket.union(handle)

# Save the final model
result.val().exportStl("Refine_1.stl")
