
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(10, 10).extrude(5)

# Create a workplane centered on the face where the slot should be created
slot = base.faces(">Z").workplane().rect(5, 5).cutBlind(-3)  # This guarantees the slot is centered on top face and cuts into the base object

# Export the result with a revised name to avoid confusion
base.val().exportStl("Refine_1.stl")
