
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(10, 10).extrude(5)

# Create a workplane centered on the face where the slot should be created
# Ensure that the slot cuts through sufficiently to be visible
slot = base.faces(">Z").workplane().rect(5, 5).cutBlind(-5)  # Increase the depth of the cut to match the extrusion height

# Export the result with a revised name to avoid confusion and following the second task requirement
base.val().exportStl("Refine_2.stl")
