
import cadquery as cq

def make_fillet_on_edges(workplane, selector):
    # Apply fillets on the edges selected by the selector
    to_fillet = workplane.edges(selector).fillet(0.3)
    return to_fillet

# Create a rectangle
result = cq.Workplane("front").rect(10, 2)

# Fillet only two corners of one of the longer edges
# The corners on the longer edge at y=1
result = result.edges("|Z and <X and <Y").vertices(">Y").fillet(0.3)
result = result.edges("|Z and >X and <Y").vertices(">Y").fillet(0.3)

# Extrude the sketch with filleted edges
result = result.extrude(1)

# Verify and export the object
solid = result
solid.val().exportStl("Refine_2.stl")
