
import cadquery as cq

# Parameters for the mold
outer_size = 100.0  # Size of the outer square
inner_size = 90.0  # Size of the inner square
corner_radius = 10.0  # Radius of the corners
extrude_height = 20.0  # Height of the extrusion

# Create the outer square with rounded corners
outer_square = (
    cq.Workplane("XY")
    .rect(outer_size, outer_size, forConstruction=False)
    .vertices()
    .fillet(corner_radius)
)

# Extrude the outer square
outer_part = outer_square.extrude(extrude_height)

# Create the inner square with rounded corners on the top face of the outer square
inner_square = (
    outer_part.faces(">Z")
    .workplane()
    .rect(inner_size, inner_size, forConstruction=False)
    .vertices()
    .fillet(corner_radius)
)

# Negatively extrude this square to create a void
result = inner_square.cutBlind(-extrude_height)

# Export the result
result.val().exportStl("Refine_2.stl")
