
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(10, 20).extrude(5)

# Create the L-shaped block, ensuring it starts at the correct position and has distinct corners
l_block = (
    cq.Workplane("XY")
    .workplane(offset=5)
    .moveTo(5, 10)  # Correctly moving to start the L at the top right front of the rectangle
    .hLine(5)  # horizontal line, making the L wider
    .vLine(-5)  # dropping down to form the L
    .hLine(-3)  # connecting back to create the inner L part
    .vLine(3)  # completing the inner part of the L
    .hLine(-2)  # closing the L
    .close()
    .extrude(5)
)

# Combine the base and the L-shaped block
result = base.union(l_block)

# Export the refined result
result.val().exportStl("Refine_2.stl")
