
import cadquery as cq

# Define the dimensions
circle_diameter = 10.0
rectangle_width = 1.0
rectangle_height = 7.0 * rectangle_width  # Ensuring the height is 7 times the width
hole_diameter = 0.5
extrude_depth = 2.0

# Creating the initial sketch on a workplane
result = cq.Workplane("front")

# Drawing the circle with half the diameter for radius
circle_radius = circle_diameter / 2
result = result.circle(circle_radius)

# Drawing the rectangle; the bottom of it should be at the bottom of the circle
rectangle_start_y = -circle_radius
result = result.moveTo(0, rectangle_start_y).vLine(rectangle_height).hLine(rectangle_width). \
    vLine(-rectangle_height).close()

# Drawing the hole near the top edge of the rectangle
hole_offset_y = rectangle_start_y + rectangle_height - hole_diameter/2 - 1  # minor offset of 1 from the top
result = result.pushPoints([(0, hole_offset_y)]).circle(hole_diameter / 2.0)

# Extrude the entire sketch to form a 3D object
result = result.extrude(extrude_depth)

# Exporting the result to an STL file
result.val().exportStl("Refine_1.stl")
