
import cadquery as cq

# Define the dimensions
circle_diameter = 10.0
rectangle_width = 1.0
rectangle_height = 7.0 * rectangle_width  # Ensuring the height is 7 times the width
hole_diameter = 0.5
extrude_depth = 2.0

# Creating the initial sketch on a workplane
result = cq.Workplane("front")

# Drawing the circle with half the diameter for radius
circle_radius = circle_diameter / 2
result = result.circle(circle_radius)

# Calculating the starting point for the rectangle
rectangle_start_y = -circle_radius

# Adjusting rectangle starting position to correctly sit at the circle's edge
result = result.rect(rectangle_width, rectangle_height, centered=False) \
   .translate((circle_radius, rectangle_start_y + rectangle_height / 2.0, 0))

# Drawing the hole near the top edge of the rectangle
hole_center_y = rectangle_start_y + rectangle_height - hole_diameter/2 - 1  # minor offset of 1 from the top
result = result.pushPoints([(circle_radius, hole_center_y)]).circle(hole_diameter / 2.0)

# Extrude the entire sketch to form a 3D object
result = result.extrude(extrude_depth)

# Exporting the result to an STL file
result.val().exportStl("Refine_2.stl")
