
import cadquery as cq

# Create a rectangular plate
plate = cq.Workplane("XY").box(80, 20, 5)

# Function to create a square cutout with fully rounded edges
# Making sure cutout is correctly positioned for negative extrusion
def make_cutout(workplane, x_position):
    return (workplane
            .workplane(centerOption="CenterOfBoundBox")  # Ensuring we're operating in the context of existing solids
            .pushPoints([(x_position, 0)])  # Positioning the center of the upcoming shape
            .rect(10, 10, forConstruction=False)
            .vertices()
            .fillet(2)
            .cutBlind(-5))  # Direct negative extrusion without needing translate()

# Apply cutouts to the plate
result = make_cutut(plate, 5)    # First cutout
result = make_cutut(result, 75)  # Second cutout

# Export the result as 'Refine_1.stl' as specified
result.val().exportStl("Refine_1.stl")
