
import cadquery as cq

# Parameters
base_length = 10.0
height = 15.0
corner_radius = 1.0
hole_radius = 0.2
top_cut_position = 0.6  # Position of the top cut relative to height (as a fraction)

# Create the initial isoceles triangle
triangle = (
    cq.Workplane("XY")
    .moveTo(-base_length / 2, 0)
    .lineTo(base_length / 2, 0)
    .lineTo(0, height)
    .close()
)

# Create the modified triangle with the top cut off and rounded corners
triangle_cut = (
    triangle
    .workplane()
    .split(keepBottom=True,
           keepTop=False,
           wire=cq.Workplane("XY").moveTo(0, height * top_cut_position).lineTo(base_length / 2, 0).lineTo(-base_length / 2, 0).close())
)

# Adjust triangle vertices for hole placements
new_vertices = triangle_cut.vertices().vals()

# Extrude the triangle
ext_triangle = triangle_cut.extrude(1.0)

# Add fillets to the bottom corners
ext_triangle = ext_triangle.edges("not(<X or >X)").fillet(corner_radius)

# Drill holes near each corner
for vert in new_vertices:
    ext_triangle = ext_triangle.faces(">Z or <Z").workplane(centerOption="CenterOfMass").pushPoints([vert.Center().toTuple()]).hole(hole_radius)

# Export the modified model
ext_triangle.val().exportStl("Refine_1.stl")
