
import cadquery as cq
import math

# Define the points for the irregular pentagon
points = [(0, 0), (2, 1), (1, 3), (-1, 3), (-2, 1)]

# Calculate the height of the pentagon as the difference between the max and min y-values
pentagon_height = max(points, key=lambda x: x[1])[1] - min(points, key=lambda x: x[1])[1]

# Create the workplane and draw the pentagon
r = cq.Workplane("front").polyline(points).close()

# Extrude the sketch to create the 3D pentagonal prism, extrusion is almost two times the pentagon height
result = r.extrude(2 * pentagon_height * 0.95)  # Using 0.95 to approximate "almost two times"

# Save the output
result.val().exportStl("Refine_1.stl")
