
import cadquery as cq

# Parameters for the desk and legs
desk_length = 100.0
desk_width = 60.0
desk_thickness = 2.0
leg_length = 50.0
leg_width = 10.0
leg_depth = 10.0
cutout_size = 5.0

# Create the desk surface without cutouts
desk = (
    cq.Workplane("XY")
    .box(desk_length, desk_width, desk_thickness)
)

# Create the legs
leg = (
    cq.Workplane("XY")
    .box(leg_width, leg_depth, leg_length)
)

# Position the legs and combine with the desk
desk = (
    desk
    .faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    .center(-desk_length / 4, 0)
    .add(leg)
    .center(desk_length / 2, 0)
    .add(leg)
)

desk.exportStl("Generated.stl")
