
import cadquery as cq
import math

# Define the side length of the equilateral triangle
side_length = 10.0

# Calculate the height of the equilateral triangle using simple trigonometry
height = side_length * (math.sqrt(3) / 2)

# Define the radius of the semicircular cutout; diameter is 2/3 of the side length
radius = (side_length * 2 / 3) / 2

# Points of the equilateral triangle pointing downwards
pts = [
    (0, height / 2),  # Top vertex
    (-side_length / 2, -height / 2),  # Bottom left vertex
    (side_length / 2, -height / 2),  # Bottom right vertex
]

# Create the base triangle workplane
base_triangle = cq.Workplane("front").polyline(pts).close()

# Cutout a semicircle from the bottom right corner
# Calculate the center of the semicircle properly
cutout_center = (side_length / 2 - radius, -height / 2)

# Perform the semicircular cutout using the center
result = base_triangle.moveTo(cutout_center[0], cutout_center[1]).\
    threePointArc((cutout_center[0] - radius, cutout_center[1]), (cutout_center[0], cutout_center[1] + radius)).\
    lineTo(side_length / 2, -height / 2).close()

# Extrude the sketch to create a 3D object
final_result = result.extrude(10.0)

# Save the result
final_result.val().exportStl("Refine_2.stl")
