
import cadquery as cq

# Parameters for the box
base_width = 20.0
base_height = 10.0
base_depth = 1.0
wall_thickness = 1.0
wall_height = 10.0
chamfer_size = 0.5

# Create the base of the box
base = cq.Workplane("XY").rect(base_width, base_height).extrude(base_depth)

# Create the walls of the box using two concentric rectangles to ensure open top
walls = (
    base.faces(">Z")
    .workplane()
    .rect(base_width, base_height)
    .rect(base_width - 2 * wall_thickness, base_height - 2 * wall_thickness, forConstruction=True)
    .extrude(wall_height)
)

# Calculating appropriate chamfer size to avoid geometric issues
min_edge_length = min(base_width - 2 * wall_thickness, base_height - 2 * wall_thickness)
safe_chamfer_size = min(chamfer_size, min_edge_length / 2)

# Applying chamfer to inner edges of the walls
walls = walls.edges("|Z and <Y").champer(safe_chamfer_size)

# Combine the base and the walls to get the final box
box = base.union(walls)

# Corrected - Export the final 3D object with the correct file name
box.val().exportStl("Refine_1.stl")
