
import cadquery as cq
import math

# Define the dimensions
base_length = 10.0  # Length of the base
top_length = 5.0  # Length of the top
height = 7.0  # Height of the trapezoid
extrude_amount = 2.0  # Amount to extrude the sketch
base_angle_deg = 70  # Base angle in degrees

# Calculate the necessary dimensions
base_angle_rad = math.radians(base_angle_deg)  # Convert base angle to radians
height_adj = height / 2  # half height of trapezoid
leg_length = height_adj / math.cos(base_angle_rad)  # leg length using trapezoid relation
half_base_length = base_length / 2
half_top_length = top_length / 2

# Define a function to generate points based on geometry
def trapezoid_points(hb, ht, leg, angle):
    # Calculate coordinates using base and leg lengths with base angle
    delta_x = leg * math.sin(angle)
    delta_y = leg * math.cos(angle)
    return [(-hb, 0), (-ht + delta_x, delta_y),
             (ht - delta_x, delta_y), (hb, 0)]

# Get points and create the trapezoid
points = trapezoid_points(half_base_length, half_top_length, leg_length, base_angle_rad)
result = (cq.Workplane("front")
          .moveTo(points[0][0], points[0][1])
          .lineTo(points[1][0], points[1][1])
          .lineTo(points[2][0], points[2][1])
          .lineTo(points[3][0], points[3][1])
          .close()
          .extrude(extrude_amount))

# Export the result
result.val().exportStl("Refine_1.stl")
