
import cadquery as cq

# Create the first larger rectangle
first_rectangle = cq.Workplane("front").rect(10, 20).extrude(1)

# Create the second smaller rectangle, adjusting its position to start halfway up the first rectangle
# Increased x-coordinate by 10 (width of the first rectangle) to position on the right edge
# Updated y-coordinate by 10 (half of the height of the first rectangle) for connection from halfway up
second_rectangle = cq.Workplane("front").rect(5, 10).translate((10, 10, 0)).extrude(1)

# Combine the two rectangles
result = first_rectangle.union(second_rectangle)

# Save the corrected output
result.val().exportStl("Refine_V_1.stl")
