
import cadquery as cq

# First rectangle
first_rectangle = cq.Workplane("front").rect(10, 20).extrude(1)

# Second rectangle
# Translated to connect on the right edge of the first rectangle, starting halfway up
second_rectangle = cq.Workplane("front").rect(5, 10).translate((10 + 2.5, 20 / 2, 0)).extrude(1)

# Combine the two rectangles
result = first_rectangle.union(second_rectangle)

result.val().exportStl("Refine_V_2.stl")
