
import cadquery as cq

# Adjusted dimensions as per feedback
diameter = 150.0  # Increase the diameter significantly
height = 50.0     # Height remains the same
cutout_diameter = 20.0  # Diameter of the central circular cutout

# Creating the main cylinder
result = cq.Workplane("XY").circle(diameter / 2.0).extrude(height)

# Creating the cutout throughout the height of the cylinder
result = result.faces(">Z").workplane().circle(cutout_diameter / 2.0).cutThruAll()

# Export the final model to an STL file
result.val().exportStl("Refine_V_1.stl")
