
import cadquery as cq

# Constants to define the cylinder and cut dimensions
cylinder_diameter = 10
cylinder_radius = cylinder_diameter / 2
cylinder_height = 20
cut_width = cylinder_diameter / 4
cut_height = cylinder_height / 4

# Create the main cylinder
cylinder = cq.Workplane("XY").circle(cylinder_radius).extrude(cylinder_height)

# Define the cutting tool for removing the portion. The tool is a box whose one corner is placed at 1/4th the height of the cylinder.
cutting_tool = cq.Workplane("XY") \
    .workplane(offset=cylinder_height - cut_height) \
    .rect(cylinder_diameter, cut_width) \
    .extrude(cut_height)

# Cut the portion out of the cylinder using the cutting tool
result = cylinder.cut(cutting_tool)

# Export the adjusted model to an STL file
result.val().exportStl("Refine_V_1.stl")
