
import cadquery as cq

length = 10.0
width = 10.0
height = 0.5

# Create the first rectangle
base = cq.Workplane("XY").box(length, width, height)

# Create the second rectangle
# The second rectangle must be rotated 90 degrees around the Z axis so that they intersect perpendicularly
second = (cq.Workplane("XY")
          .transformed(offset=(-length / 2, 0, height / 2))  # Shift it to make it start from the middle edge
          .transformed(rotate=(90, 0, 0))  # Rotated 90 degrees around Z-axis
          .box(length, width, height))

# Union the two rectangles to form a single object
result = base.union(second)

# Export the result to an STL file
result.val().exportStl("Refine_V_2.stl")
