
import cadquery as cq

# Define the dimensions of the main rectangle and the cut-out
main_length = 10.0
main_width = 5.0
main_height = 0.5

cutout_length = 4.0
cutout_width = 2.0
cutout_height = 0.5

# Define the z-offset to position the cutout slightly above the midpoint total height
z_offset = main_height / 4  # Positions the cutout 1/4th the height above the base plane

# Create the main block
result = cq.Workplane("XY").box(main_length, main_width, main_height)

# Create the cut-out
result = result.faces(">Z").workplane(offset=z_offset)\
    .rect(cutout_length, cutout_width)\
    .cutThruAll()

# Export the modified design to an STL file
result.val().exportStl("Refine_V_2.stl")
