
import cadquery as cq

outer_radius = 10.0
inner_radius = 0.5  # Decreased to make the inner radius visibly much smaller
height = 50.0

outer_cylinder = cq.Workplane("XY").circle(outer_radius).extrude(height)
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

result = outer_cylinder.cut(inner_cylinder)

result.val().exportStl("Refine_V_2.stl")
