
import cadquery as cq

# Create the first bigger cylinder
cylinder1 = cq.Workplane("XY").circle(10).extrude(20)

# Create the second smaller yet taller cylinder
cylinder2 = cq.Workplane("XY").circle(8).extrude(50)

# Resulting object by combining cylinder1 and cylinder2
result = cylinder1.union(cylinder2)

# Export the result as an STL file named "Refine_V_2.stl"
result.val().exportStl("Refine_V_2.stl")
