
import cadquery as cq

length = 100.0  # dimension along the x-axis
width = 50.0    # dimension along the y-axis
thickness = 1.0 # extrusion height along the z-axis

result = (
    cq.Workplane("XY")  # Start a new workplane that is oriented in the XY plane
    .rect(length, width)  # Create a rectangle with given dimensions on the workplane
    .extrude(thickness)   # Extrude the 2D shape to 3D
)

result.val().exportStl("Refine_V_1.stl")  # Export the 3D model as STL file with the new file name
