
import cadquery as cq

# Define the points of a right triangle
points = [(0, 0), (1, 0), (0, 1)]

# Create a workplane to draw the triangle on
triangle = cq.Workplane("XY").polyline(points).close()

# Extrude the 2D triangle shape to create a 3D object
result = triangle.extrude(1)

# Save the object as an STL file
result.val().exportStl("Refine_V_1.stl")
