
import cadquery as cq

length = 100.0
width = 50.0
thickness = 10.0
hole_dia = 5.0
hole_offset = 10.0

# Create a box
result = cq.Workplane("XY").box(length, width, thickness)

# List of positions for the holes, each near a different corner
positions = [
    (-length / 2 + hole_offset, -width / 2 + hole_offset),
    (length / 2 - hole_offset, -width / 2 + hole_offset),
    (length / 2 - hole_offset, width / 2 - hole_offset),
    (-length / 2 + hole_offset, width / 2 - hole_offset)
]

# Add holes to each of the specified positions
for position in positions:
    result = result.faces(">Z").workplane().center(*position).hole(hole_dia)

# Export the STL file
result.val().exportStl("Refine_V_1.stl")
