
import cadquery as cq

# Re-defining dimensions as per user feedback
length = 100.0  # maintaining the same length
width = 75.0    # increasing width from 50.0 to 75.0 to make it wider
height = 5.0    # decreasing height from 10.0 to 5.0 to make it shorter

# Constructing the new rectangular prism with updated dimensions
result = cq.Workplane("XY").box(length, width, height)

# Exporting the model to a STL file named "Refine_V_1.stl"
result.val().exportStl("Refine_V_1.stl")
