
import cadquery as cq

# Define the dimensions of the rectangle and cylinder as per updated requirements
rect_width = 10.0
rect_length = rect_width * 5  # Ensuring the length is 5 times the width
rect_height = 5.0
cylinder_radius = rect_width / 3  # Setting the radius as 1/3 of the width
cylinder_height = rect_height * 2

# Create the rectangular box
result = cq.Workplane("XY").box(rect_length, rect_width, rect_height)

# Add the cylinder to one side of the rectangle, very close to the edge
result = result.faces(">Y").workplane()\
    .moveTo(-rect_length / 2 + cylinder_radius, 0)\
    .circle(cylinder_radius).extrude(cylinder_height)

# Save the modified design to an STL file
result.val().exportStl("Refine_V_2.stl")
