
import cadquery as cq

# Create a cylinder with a diameter of 20mm and height of 5mm
cylinder = cq.Workplane("XY").circle(10.0).extrude(5.0)  # Diameter = 2 * 10mm

# Create a rectangular prism with dimensions slightly larger than the cylinder's diameter
# Length = 22mm (greater than the diameter of the cylinder), width = 2mm, height = 2mm
rect_prism = cq.Workplane("XY").box(22.0, 2.0, 2.0)

# Translate the rectangular prism so that it is centered on the cylinder and positioned on top
rect_prism = rect_prism.translate((0, 0, 7.5))  # Correct the position to place it on top of the cylinder

# Combine the cylinder and rectangular prism into a single shape
result = cylinder.union(rect_prism)

# Save the result as an STL file
result.val().exportStl("Refine_V_1.stl")
