
import cadquery as cq

# Set dimensions where width is half the length as required
width = 10.0
length = 2 * width

result = (
    cq.Workplane("XY")
    .rect(length, width)  # Rectangle with length twice the width
    .extrude(5.0)         # Extrude height remains the same as it's consistent
)

result.val().exportStl("Refine_V_2.stl")
