
import cadquery as cq

# Define dimensions
length = 100.0
width = 20.0
height = 20.0
cutout_length = length / 4
cutout_height = height * 3 / 4
cutout_width = width

# Create main solid (rectangular prism)
result = cq.Workplane("XY").box(length, width, height)

# Define and perform the cutout operation
cutout = (
    cq.Workplane("XY")
    .workplane(offset=height - cutout_height)  # Adjust workplane to the cutout height
    .moveTo(length - cutout_length / 2, 0)  # Move to the correct position for the cutout
    .rect(cutout_length, cutout_width)  # Define the rectangle for cutout
    .extrude(-cutout_height, combine=False)  # Extrude negatively (cutting)
)

# Apply the cutout to the main solid
result = result.cut(cutout)

# Export the final shape to an STL file
result.val().exportStl("Refine_V_2.stl")
