
import cadquery as cq

# Define the dimensions of the plate and holes
plate_length = 100.0
plate_width = 50.0
plate_thickness = 10.0
hole_diameter = 5.0
hole_offset = 10.0

# Create the plate
result = (
    cq.Workplane("XY")
    .box(plate_length, plate_width, plate_thickness)
)

# Cut the holes
for offset in [-hole_offset, hole_offset]:
    result = (
        result.faces(">Z")
        .workplane()
        .center(offset, 0)
        .hole(hole_diameter)
    )

# Export the result
result.val().exportStl("Generated.stl")
