
import cadquery as cq
import random

# Define the random seed for reproducibility
random.seed(42)

# Create the base rectangle and extrude
result = cq.Workplane("XY").rect(10, 20).extrude(5)

# Cut a circular hole at the midpoint of the rectangle
result = result.faces(">Z").workplane().circle(2).cutThruAll()

# Creating a jagged slit by varying coordinates and depth slightly
slit_length = 10
slit_width = 0.2
for i in range(10):  # Create more cuts to emphasize the jagged effect
    dx = random.uniform(-0.5, 0.5)  # Slight horizontal variation
    dy = random.uniform(-0.5, 0.5)  # Slight vertical variation from the centerline
    slit_length_variation = random.uniform(-1, 1)
    result = result.faces(">Z").workplane().transformed(
        offset=(dx, 10 + dy, 0), rotate=(0, 0, random.uniform(-5, 5))
    ).rect(slit_width, slit_length + slit_length_variation).cutBlind(-5 - random.uniform(0, 0.5))  # Randomly vary depth

# Save the output
result.val().exportStl("Refine_V_2.stl")
