
import cadquery as cq

circle_dia = 10.0  # diameter of the circle
hole_dia = 1.0     # diameter of each hole
hole_offset = 3.5  # distance from the center to the center of each hole

# Create a base cylinder
result = cq.Workplane("XY").circle(circle_dia / 2.0).extrude(1.0)

# Create four holes in a square configuration
for x in [-hole_offset, hole_offset]:
    for y in [-hole_offset, hole_offset]:
        result = result.faces(">Z").workplane().center(x, y).hole(hole_dia)

# Save the result as an STL file
result.val().exportStl("Refine_V_2.stl")
