
import cadquery as cq

# Define dimensions
U_width = 10.0
U_height = 20.0
U_thickness = 2.0
rectangle_width = U_width + 4 * U_thickness  # Increased width for better coverage
rectangle_height = U_thickness
extrusion_depth = 10.0  # Define the depth of the extrusion

# Create a solid U-shape
u_shape_base = cq.Workplane("front")\
    .moveTo(-U_width / 2 - U_thickness, 0)\
    .vLine(U_height)\
    .hLine(U_width + 2 * U_thickness)\
    .vLine(-U_height)\
    .close()\
    .extrude(extrusion_depth)

# Create the rectangle to close the open part of U
rectangle = cq.Workplane("front")\
    .moveTo(-rectangle_width / 2, U_height)\
    .rect(rectangle_width, rectangle_height)\
    .extrude(extrusion_depth)

# Union the solid U-shape with the rectangle
result = u_shape_base.union(rectangle)

# Save the result as an STL file
result.val().exportStl("Refine_V_1.stl")
