
import cadquery as cq

# Define a sketch on the XY plane.
points_h = [
    (0, 0), (3, 0),  # Bottom left to bottom bar right
    (3, 5), (7, 5),  # Vertical left bar
    (7, 0), (10, 0),  # Top bar from left to right
    (10, 8), (7, 8),  # Vertical right bar
    (7, 10), (0, 10)  # Top to left top bar
]

# Create a closed polyline for the sketch resembling letter 'h'.
sketch_h = cq.Workplane("XY").polyline(points_h).close()

# Define bench legs for additional details; simple extrude of smaller rectangles.
leg_1 = cq.Workplane("XY", origin=(1, 0)).box(2, 1, 4)
leg_2 = cq.Workplane("XY", origin=(8, 0)).box(2, 1, 4)

# Create the extruded benches, combining with legs.
bench_body = sketch_h.extrude(1.5)  # Extrude bench body
bench_legs = leg_1.union(leg_2)  # Union of legs

# Assemble the full bench with seating area and legs
full_bench = bench_body.union(bench_legs.translate((0, -1.5, -4)))

# Export refined bench model as STL.
full_bench.val().exportStl("Refine_V_2.stl")
