
import cadquery as cq

outer_size = 10.0  # define the outer size of the rectangle
inner_size = 8.0   # define the inner size of the rectangle
length = 20.0      # length to extrude the rectangles

# Create a rectangular tube by extruding a square and cutting a smaller one through it along the Y-axis
result = cq.Workplane("XZ").rect(outer_size, outer_size).extrude(length)
result = result.faces(">Y").workplane().rect(inner_size, inner_size).cutBlind(-length)
result = result.faces("<Y").workplane().rect(inner_size, inner_size).cutBlind(length)

# Export the result as an STL file
result.val().exportStl("Refine_V_1.stl")
