
import cadquery as cq

# Define the points of a rhombus. Assume all sides are equal, and the figure is centered at the origin
size = 2
height = 2
points = [(0, size), (size / 2, 0), (0, -size), (-size / 2, 0)]

# Create the workplane, form the rhombus and extrude it
result = cq.Workplane("XY").polyline(points).close().extrude(height)

# Save the result as STL
result.val().exportStl("Refine_V_2.stl")
