
import cadquery as cq

# Main U-shaped body
U_shape = (
    cq.Workplane("XY")
    .moveTo(-1.5, 0)
    .lineTo(1.5, 0)
    .lineTo(1.5, 2)
    .lineTo(-1.5, 2)
    .close()
    .extrude(1)  # Extrusion height for the U-shape
)

# Square on the left slightly overlapping with U's bottom left corner
square_left = (
    cq.Workplane("XY")
    .moveTo(-1.7, -0.1)  # Position slightly outside the U shape
    .rect(1, 1)  # Square size
    .extrude(1)  # Making sure extrusion height matches the U-shape
)

# Square on the right slightly overlapping with U's bottom right corner
square_right = (
    cq.Workplane("XY")
    .moveTo(1.7, -0.1)  # Position slightly outside the U shape
    .rect(1, 1)  # Square size
    .extrude(1)  # Making sure extrusion height matches the U-shape
)

# Combine all shapes into one result
result = U_shape.union(square_left).union(square_right)

# Export the final result
result.val().exportStl("Refine_V_2.stl")
