
import cadquery as cq

# Define dimensions
square_size = 10.0
rectangle_width = square_size / 5
rectangle_length = square_size
extrusion_length = 5.0

# Create the main square body
result = cq.Workplane("XY").box(square_size, square_size, extrusion_length, centered=(True, True, False))

# Attach rectangles to the left and right sides and extrude in the opposite direction of the main square (z-axis)
# This extrudes the rectangles outward from the square on both sides
left_rect = result.faces("<Y").workplane(centerOption="CenterOfBoundBox").rect(rectangle_width, rectangle_length).extrude(-extrusion_length)
right_rect = result.faces(">Y").workplane(centerOption="CenterOfBoundBox").rect(rectangle_width, rectangle_length).extrude(-extrusion_length)

# Union the rectangles with the central square body
final_result = result.union(left_rect).union(right_rect)

# Export the final model as STL
final_result.val().exportStl("Refine_V_2.stl")
