
import cadquery as cq

# Create the first extruded cylinder
cylinder1 = cq.Workplane("XY").circle(10).extrude(5)

# Create the second extruded cylinder
cylinder2 = cq.Workplane("XY").circle(5).extrude(5)

# Cut the second cylinder from the first to create a hole
result = cylinder1.cut(cylinder2)

# Position and cut a rectangle next to the second cylinder
#  -5 in X direction to position the rectangle on the right side of the second cylinder
# rect(2, 5) creates a rectangle of width 2 and height 5.
cutout = result.faces(">Z").workplane().center(-5, 0).rect(2, 5).cutThruAll()

# Export the final result as an STL file
cutout.val().exportStl("Refine_V_1.stl")
